/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity.projectile;

import baguchan.hunterillager.init.HunterEnchantments;
import baguchan.hunterillager.init.HunterEntityRegistry;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BoomerangEntity
extends ThrowableEntity {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PIERCING_LEVEL = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> BOUNCE_LEVEL = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> RETURNING = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> BOOMERANG = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private int totalHits;
    private int flyTick;

    public BoomerangEntity(EntityType<? extends BoomerangEntity> entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, World world, LivingEntity shootingEntity, ItemStack boomerang) {
        super(type, shootingEntity, world);
        this.func_212361_a((Entity)shootingEntity);
        this.setBoomerang(boomerang);
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)boomerang)));
        this.field_70180_af.func_187227_b(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)boomerang)));
        this.field_70180_af.func_187227_b(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)HunterEnchantments.BOUNCE, (ItemStack)boomerang)));
        this.totalHits = 0;
    }

    public BoomerangEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(HunterEntityRegistry.BOOMERANG, world);
    }

    public BoomerangEntity(World world, LivingEntity entity, ItemStack boomerang) {
        this(HunterEntityRegistry.BOOMERANG, world, entity, boomerang);
    }

    private void onHitFluid(BlockRayTraceResult result) {
        double velocity = this.getVelocity();
        double horizontal = this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b;
        if (!this.field_70170_p.field_72995_K && result.func_216346_c() == RayTraceResult.Type.BLOCK && result.func_216353_d() && velocity >= (double)0.65f && horizontal < (double)0.175f && !this.field_70170_p.func_180495_p(result.func_216350_a()).func_196958_f() && this.field_70170_p.func_204610_c(result.func_216350_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, MathHelper.func_151237_a((double)(this.func_213322_ci().field_72448_b + (double)0.1f), (double)-0.1f, (double)0.3f), this.func_213322_ci().field_72449_c);
            this.field_70160_al = true;
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity shooter;
        super.func_213868_a(result);
        boolean returnToOwner = false;
        byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.field_70180_af.func_187225_a(PIERCING_LEVEL);
        Entity entity = this.func_234616_v_();
        if (!(result.func_216348_a() == this.func_234616_v_() || this.isReturning() && loyaltyLevel > 0)) {
            shooter = this.func_234616_v_();
            int sharpness = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)this.getBoomerang());
            result.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)shooter), (float)(3.0 * Math.sqrt(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b * 0.5 + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c) + (double)Math.min(1, sharpness) + (double)Math.max(0, sharpness - 1) * 0.5) + 0.5f * (float)piercingLevel);
            if (shooter instanceof LivingEntity) {
                this.getBoomerang().func_222118_a(1, (LivingEntity)shooter, p_222182_1_ -> {});
            }
            double speed = this.getSpeed();
            if (piercingLevel < 1 && this.totalHits >= this.getBounceLevel() || this.totalHits >= piercingLevel + this.getBounceLevel() && speed > (double)0.4f) {
                returnToOwner = true;
            } else if (piercingLevel < 1 && this.totalHits < this.getBounceLevel() || this.totalHits < piercingLevel + this.getBounceLevel() && speed <= (double)0.4f) {
                Vector3d motion = this.func_213322_ci();
                double motionX = motion.field_72450_a;
                double motionY = motion.field_72448_b;
                double motionZ = motion.field_72449_c;
                motionX = -motionX;
                motionZ = -motionZ;
                this.func_213293_j(motionX, motionY, motionZ);
            }
            ++this.totalHits;
        }
        if (returnToOwner && !this.isReturning()) {
            if (this.func_234616_v_() != null && this.shouldReturnToThrower() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)this.getBoomerang()) > 0) {
                shooter = this.func_234616_v_();
                this.field_70170_p.func_184133_a(null, shooter.func_233580_cy_(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
                Vector3d motion = this.func_213322_ci();
                double motionX = motion.field_72450_a;
                double motionY = motion.field_72448_b;
                double motionZ = motion.field_72449_c;
                motionX = -motionX;
                motionZ = -motionZ;
                this.func_213293_j(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && entity != null) {
                    this.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            } else {
                Vector3d motion = this.func_213322_ci();
                double motionX = motion.field_72450_a;
                double motionY = motion.field_72448_b;
                double motionZ = motion.field_72449_c;
                motionX = -motionX;
                motionZ = -motionZ;
                this.func_213293_j(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && entity != null) {
                    this.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        BlockPos pos = result.func_216350_a();
        BlockState state = this.field_70170_p.func_180495_p(pos);
        SoundType soundType = state.getSoundType((IWorldReader)this.field_70170_p, pos, (Entity)this);
        if (!this.isReturning()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundType.func_185846_f(), SoundCategory.BLOCKS, soundType.func_185843_a() * 0.45f, soundType.func_185847_b());
        }
        ++this.totalHits;
        BlockState blockstate = this.field_70170_p.func_180495_p(result.func_216350_a());
        byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.field_70180_af.func_187225_a(PIERCING_LEVEL);
        Entity entity = this.func_234616_v_();
        if (!this.isReturning() && !blockstate.func_196952_d((IBlockReader)this.field_70170_p, result.func_216350_a()).func_197766_b()) {
            Direction face = result.func_216354_b();
            Vector3d motion = this.func_213322_ci();
            double motionX = motion.field_72450_a;
            double motionY = motion.field_72448_b;
            double motionZ = motion.field_72449_c;
            if (face == Direction.EAST) {
                motionX = -motionX;
            } else if (face == Direction.SOUTH) {
                motionZ = -motionZ;
            } else if (face == Direction.WEST) {
                motionX = -motionX;
            } else if (face == Direction.NORTH) {
                motionZ = -motionZ;
            } else if (face == Direction.UP) {
                motionY = -motionY;
            } else if (face == Direction.DOWN) {
                motionY = -motionY;
            }
            this.func_213293_j(motionX, motionY, motionZ);
            if (loyaltyLevel > 0 && !this.isReturning() && this.totalHits >= this.getBounceLevel() && entity != null) {
                this.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.setReturning(true);
            }
        }
        this.func_145775_I();
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (loyaltyLevel < 1 && this.totalHits >= this.getBounceLevel() && !this.field_70170_p.func_201670_d()) {
            this.drop(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        super.func_70100_b_(entityIn);
        if (!this.field_70170_p.field_72995_K && this.flyTick >= 6 && entityIn == this.func_234616_v_()) {
            this.drop(this.func_234616_v_().func_226277_ct_(), this.func_234616_v_().func_226278_cu_(), this.func_234616_v_().func_226281_cx_());
        }
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (!this.field_70170_p.field_72995_K && this.flyTick >= 6 && entityIn == this.func_234616_v_()) {
            this.drop(this.func_234616_v_().func_226277_ct_(), this.func_234616_v_().func_226278_cu_(), this.func_234616_v_().func_226281_cx_());
        }
    }

    public void drop(double x, double y, double z) {
        if (!(this.func_234616_v_() instanceof PlayerEntity) || this.func_234616_v_() instanceof PlayerEntity && !((PlayerEntity)this.func_234616_v_()).func_184812_l_()) {
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, x, y, z, this.getBoomerang().func_77946_l()));
        }
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.flyTick;
        Vector3d vec3d = this.func_213322_ci();
        Vector3d vec3d1 = this.func_213303_ch();
        Vector3d vec3d2 = new Vector3d(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
        BlockRayTraceResult fluidRaytraceResult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1, vec3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)this));
        this.onHitFluid(fluidRaytraceResult);
        float f = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72450_a, (double)this.func_213322_ci().field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        Entity entity = this.func_234616_v_();
        if (loyaltyLevel > 0 && !this.isReturning() && this.flyTick >= 100 && entity != null) {
            this.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.setReturning(true);
        }
        if (loyaltyLevel > 0 && entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
            if (!this.field_70170_p.field_72995_K) {
                this.drop(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            }
            this.func_70106_y();
        } else if (loyaltyLevel > 0 && entity != null && this.isReturning()) {
            this.field_70145_X = true;
            Vector3d vec3d3 = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
            if (this.field_70170_p.field_72995_K) {
                this.field_70137_T = this.func_226278_cu_();
            }
            double d0 = 0.05 * (double)loyaltyLevel;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d3.func_72432_b().func_186678_a(d0)));
        }
        this.collideWithNearbyEntities();
    }

    protected float func_70185_h() {
        return this.isReturning() ? 0.0f : 0.03f;
    }

    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 5.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(PIERCING_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(BOUNCE_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(RETURNING, (Object)false);
        this.field_70180_af.func_187214_a(BOOMERANG, (Object)ItemStack.field_190927_a);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("boomerang", (INBT)this.getBoomerang().func_77955_b(new CompoundNBT()));
        nbt.func_74768_a("totalHits", this.totalHits);
        nbt.func_74757_a("returning", this.isReturning());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setBoomerang(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("boomerang")));
        this.totalHits = nbt.func_74762_e("totalHits");
        this.setReturning(nbt.func_74767_n("returning"));
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.getBoomerang())));
        this.field_70180_af.func_187227_b(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)this.getBoomerang())));
        this.field_70180_af.func_187227_b(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)HunterEnchantments.BOUNCE, (ItemStack)this.getBoomerang())));
    }

    protected void collideWithNearbyEntities() {
        List list;
        if (this.isReturning() && !(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntityPredicates.func_200823_a((Entity)this))).isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (entity != this.func_234616_v_()) continue;
                this.drop(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            }
        }
    }

    private int getBounceLevel() {
        byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        byte bounceLevel = (Byte)this.field_70180_af.func_187225_a(BOUNCE_LEVEL);
        if (loyaltyLevel > 0) {
            return 0 + bounceLevel * 8;
        }
        return 8 + bounceLevel * 8;
    }

    public boolean isReturning() {
        return (Boolean)this.field_70180_af.func_187225_a(RETURNING);
    }

    public ItemStack getBoomerang() {
        return (ItemStack)this.field_70180_af.func_187225_a(BOOMERANG);
    }

    public double getSpeed() {
        return Math.sqrt(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c);
    }

    public double getVelocity() {
        return Math.sqrt(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c);
    }

    public int getPiercingLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(PIERCING_LEVEL)).byteValue();
    }

    public void setReturning(boolean returning) {
        this.field_70180_af.func_187227_b(RETURNING, (Object)returning);
    }

    public void setBoomerang(ItemStack stack) {
        this.field_70180_af.func_187227_b(BOOMERANG, (Object)stack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

